@extends('layouts.app')

@section('content')

    <x-hero :title="$survey->title" :description="$survey->description" />

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 -mt-8 relative z-10">

        <!-- Alerts -->
        @if(session('success'))
            <div class="mb-8 bg-green-50 border-l-4 border-puren-green p-4 rounded-r-lg shadow-sm">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-puren-green" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd"
                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                clip-rule="evenodd" />
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium text-green-800">{{ session('success') }}</p>
                    </div>
                </div>
            </div>
        @endif

        @if($errors->any())
            <div class="mb-8 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg shadow-sm">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-red-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd"
                                d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                clip-rule="evenodd" />
                        </svg>
                    </div>
                    <div class="ml-3">
                        <ul class="text-sm text-red-700 list-disc pl-5">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        @endif

        <!-- Voting Form -->
        <form action="{{ route('vote.store') }}" method="POST"
            class="bg-white rounded-2xl shadow-xl border border-slate-100 p-6 sm:p-10 mb-10">
            @csrf
            <input type="hidden" name="survey_id" value="{{ $survey->id }}">

            <div class="mb-10 text-center">
                <h2 class="text-2xl font-bold text-slate-800">Ingresa a tu Candidato</h2>
                <p class="text-slate-500 text-sm mt-1">Escribe el nombre completo de la persona o proyecto por el que deseas
                    votar.</p>
            </div>

            <!-- Candidate Input -->
            <div class="mb-10 max-w-2xl mx-auto">
                <label for="candidate_name" class="block text-sm font-semibold text-slate-700 mb-2">Opción de Voto</label>
                <input type="text" name="candidate_name" id="candidate_name"
                    class="form-input block w-full rounded-lg border-2 border-slate-300 shadow-sm focus:border-puren-blue focus:ring focus:ring-puren-blue focus:ring-opacity-50 text-xl py-4 px-5 transition-colors"
                    placeholder="Ej. Juan Pérez / Proyecto XYZ" required value="{{ old('candidate_name') }}">
            </div>

            <div class="mb-10 max-w-2xl mx-auto">
                <label for="reason" class="block text-sm font-semibold text-slate-700 mb-2">Razones de tu elección
                    (Obligatorio)</label>
                <textarea name="reason" id="reason" rows="4"
                    class="form-input block w-full rounded-lg border-2 border-slate-300 shadow-sm focus:border-puren-blue focus:ring focus:ring-puren-blue focus:ring-opacity-50 text-base py-3 px-4 transition-colors"
                    placeholder="Escribe brevemente por qué consideras que esta persona o proyecto debe ser reconocido..."
                    required>{{ old('reason') }}</textarea>
                <p class="text-xs text-slate-500 mt-2">Cuéntanos por qué elegiste a este candidato. Tu opinión es muy
                    importante.</p>
            </div>

            <hr class="border-slate-100 mb-10">

            <!-- RUT Input & Submit -->
            <div class="bg-slate-50 rounded-xl p-8 max-w-2xl mx-auto border border-slate-200">
                <div class="flex flex-col md:flex-row gap-6 items-end">
                    <div class="flex-grow w-full">
                        <label for="rut" class="block text-sm font-semibold text-slate-700 mb-2">Valida tu Identidad
                            (RUT)</label>
                        <input type="text" name="rut" id="rut"
                            class="form-input block w-full rounded-lg border-2 border-slate-300 shadow-sm focus:border-puren-blue focus:ring focus:ring-puren-blue focus:ring-opacity-50 text-lg py-3 px-4 transition-colors uppercase"
                            placeholder="12345678-9" required value="{{ old('rut') }}">
                        <p class="text-xs text-slate-500 mt-2">Tu RUT se almacenará encriptado para asegurar que tu voto sea
                            anónimo y único.</p>
                    </div>
                    <div class="flex-shrink-0 w-full md:w-auto">
                        <button type="submit"
                            class="btn-primary w-full text-lg py-3.5 flex items-center justify-center gap-2">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            Emitir Voto
                        </button>
                    </div>
                </div>
            </div>

        </form>
    </div>

@endsection