@extends('layouts.app')

@section('content')

    <x-hero title="Resultados en Vivo" description="Navega por los resultados en tiempo real de la votación ciudadana." />

    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 -mt-8 relative z-10 mb-20">

        <div class="bg-white rounded-2xl shadow-xl border border-slate-100 p-6 sm:p-10">
            <div class="flex items-center justify-between mb-8 pb-4 border-b border-slate-100">
                <h2 class="text-2xl font-bold text-slate-800">{{ $survey->title }}</h2>
                <div class="bg-puren-light bg-opacity-20 text-puren-blue font-bold px-4 py-1.5 rounded-full text-sm">
                    Total Votos: {{ $survey->votes_count }}
                </div>
            </div>

            <div class="space-y-8">
                @foreach($survey->candidates->sortByDesc('votes_count') as $candidate)
                    @php
                        $percentage = $survey->votes_count > 0 ? round(($candidate->votes_count / $survey->votes_count) * 100, 1) : 0;
                    @endphp
                    <div>
                        <div class="flex justify-between items-end mb-2">
                            <div class="flex items-center gap-3">
                                <div
                                    class="w-10 h-10 rounded-full bg-slate-100 flex items-center justify-center text-slate-500 font-bold shrink-0">
                                    {{ substr($candidate->name, 0, 1) }}
                                </div>
                                <div>
                                    <span class="font-bold text-lg text-slate-800">{{ $candidate->name }}</span>
                                    @if($candidate->role)
                                        <span class="text-sm text-slate-500 ml-2">({{ $candidate->role }})</span>
                                    @endif
                                </div>
                            </div>
                            <div class="text-right">
                                <span class="font-bold text-2xl text-puren-blue">{{ $percentage }}%</span>
                                <span class="text-sm text-slate-500 block">{{ $candidate->votes_count }} votos</span>
                            </div>
                        </div>
                        <div class="w-full bg-slate-100 rounded-full h-4 overflow-hidden shadow-inner">
                            <div class="bg-puren-blue h-4 rounded-full transition-all duration-1000 ease-out relative overflow-hidden"
                                style="width: {{ $percentage }}%">
                                <div class="absolute inset-0 bg-white/20 w-full animate-pulse"></div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <div class="mt-12 text-center">
                <a href="{{ route('survey.show') }}" class="btn-outline inline-flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                    Volver a la Votación
                </a>
            </div>
        </div>

    </div>

@endsection