<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('votes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('survey_id')->constrained()->onDelete('cascade');
            $table->foreignId('candidate_id')->constrained()->onDelete('cascade');
            $table->string('rut_hash')->index();
            $table->timestamps();

            // Asegurar que un RUT solo vote una vez por encuesta
            $table->unique(['survey_id', 'rut_hash']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('votes');
    }
};
