<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Vote extends Model
{
    use HasFactory;

    protected $fillable = ['survey_id', 'candidate_id', 'rut_hash', 'reason'];

    public function survey()
    {
        return $this->belongsTo(Survey::class);
    }

    public function candidate()
    {
        return $this->belongsTo(Candidate::class);
    }
}
