<?php

namespace App\Http\Controllers;

use App\Models\Survey;
use Illuminate\Http\Request;

class SurveyController extends Controller
{
    public function show()
    {
        // RF01: Mostrar una sola encuesta abierta
        $survey = Survey::with('candidates')->where('is_active', true)->first();

        if (!$survey) {
            return view('survey.not_found');
        }

        return view('survey.show', compact('survey'));
    }

    public function results()
    {
        $survey = Survey::withCount('votes')->with([
            'candidates' => function ($query) {
                $query->withCount('votes');
            }
        ])->where('is_active', true)->first();

        if (!$survey) {
            return view('survey.not_found');
        }

        return view('survey.results', compact('survey'));
    }
}
